Attribute VB_Name = "modWMAlive"
'//////////////////////////////////////////////////////////////////////////
' modWMAlive.BAS - Copyright (c) 2002-2003 JOBnik! [Arthur Aminov, ISRAEL]
'                                          e-mail: jobnik2k@hotmail.com
'
' BASSWMA live broadcast example
' Originally translated from - wmalive.c - Example of Ian Luck
'
' Uses: API Timer
'//////////////////////////////////////////////////////////////////////////

Public Declare Function SetTimer Lib "user32" (ByVal hWnd As Long, ByVal nIDEvent As Long, ByVal uElapse As Long, ByVal lpTimerFunc As Long) As Long
Public Declare Function KillTimer Lib "user32" (ByVal hWnd As Long, ByVal nIDEvent As Long) As Long
Public Declare Sub CopyMemory Lib "kernel32" Alias "RtlMoveMemory" (Destination As Any, Source As Any, ByVal length As Long)

Public Const SAMPLERATE = 44100
Public rhandle As Long           ' encoder handle
Public time As Single           ' elapsed time
Public level As Long            ' input level
Public lastip As String         ' last client to connect
Public displaycount As Integer
Public RECORDCHAN As Long       ' Recording channel

' display error messages
Public Sub Error_(ByVal es As String)
    Call MsgBox(es & vbCrLf & "(error code: " & BASS_ErrorGetCode() & ")", vbExclamation, "Error")
End Sub

' update the status and level display
Public Sub UpdateDisplay()

    Dim text As String
    text = "Off Air"
    
    If (BASS_ChannelIsActive(RECORDCHAN)) Then
        Dim l As Long
        l = BASS_ChannelGetLevel(RECORDCHAN) ' get current level
        level = IIf(level > 5, level - 5, 0)
        If (LoWord(l) > level) Then level = LoWord(l)
        If (HiWord(l) > level) Then level = HiWord(l)
        If (displaycount And 128) Then
            If (displaycount And 64) Then   ' display last client
                text = "last: " & lastip
            Else    ' display client count
                text = "current clients: " & BASS_WMA_EncodeGetClients(rhandle)
            End If
        Else    ' display "On Air"
            Dim t As Long
            t = CLng(time)
            text = "On Air - port: " & BASS_WMA_EncodeGetPort(rhandle) & " - " & Int(t / 60) & ":" & Int(t Mod 60)
        End If
        displaycount = displaycount + 1
    Else
        level = 0
    End If
    
    With frmWMAlive
        'draw the level bar
        .picLevelBar.Cls
        .picLevelBar.Line (.picLevelBar.Width, .picLevelBar.Height)-(0, .picLevelBar.Height * (128 - level) / 128), vbWhite, BF:
        
        'update status text
        .lblOffAir.Caption = text
    End With
    
End Sub

' recording callback
Public Function RecordingCallback(ByVal handle As Long, ByVal buffer As Long, ByVal length As Long, ByVal user As Long) As Long
    time = time + (length / CSng((SAMPLERATE * 4))) ' increase elapsed time counter
    'encode the sample data, and continue recording if successful
    RecordingCallback = BASS_WMA_EncodeWrite(rhandle, buffer, length)
End Function

' client connection notification callback
Public Sub ClientConnect(ByVal handle As Long, ByVal connect As Long, ByVal ip As Long, ByVal user As Long)
    If (connect) Then lastip = VBStrFromAnsiPtr(ip)     'keep the client's ip for display
End Sub

' start recording & encoding
Public Sub Start()
    
    With frmWMAlive
        Dim bitrate As Long
        'get bitrate
        bitrate = Val(.cmbBitrate.List(.cmbBitrate.ListIndex))
        'initialize encoder - let system choose port, max 5 clients
        rhandle = BASS_WMA_EncodeOpenNetwork(SAMPLERATE, BASS_WMA_ENCODE_TAGS Or BASS_WMA_ENCODE_SCRIPT, bitrate, 0, 5)
        If (rhandle = 0) Then
            Call Error_("Can't initialize encoding")
            Exit Sub
        End If
        
        Dim title As String
        'get title
        title = Trim(.txtTitle.text)
        Call BASS_WMA_EncodeSetTag(rhandle, "Title", title) ' set WMA title tag
        Call BASS_WMA_EncodeSetTag(rhandle, vbNullString, vbNullString)  ' done setting tags
        Call BASS_WMA_EncodeSetNotify(rhandle, AddressOf ClientConnect, 0)   ' setup client notification
        time = 0
        displaycount = 0
        'start recording
        RECORDCHAN = BASS_RecordStart(SAMPLERATE, 0, AddressOf RecordingCallback, 0)
        If (RECORDCHAN = 0) Then
            Call Error_("Can't start recording")
            Call BASS_WMA_EncodeClose(rhandle)
            Exit Sub
        End If
        
        .btnStart.Caption = "Stop"
        .txtTitle.Enabled = False
        .cmbBitrate.Enabled = False
        .txtCaption.Enabled = True
        Call SetTimer(.hWnd, 0, 50, AddressOf TimerCallback) 'timer to update the display
    End With
End Sub

'stop recording & encoding
Public Sub Stop_()
    With frmWMAlive
        Call KillTimer(.hWnd, 0)
        Call BASS_ChannelStop(RECORDCHAN)  ' stop recording
        Call BASS_WMA_EncodeClose(rhandle)  ' stop encoding
        .btnStart.Caption = "Start"
        .txtTitle.Enabled = True
        .cmbBitrate.Enabled = True
        .txtCaption.Enabled = False
        Call UpdateDisplay
    End With
End Sub

'API Timer CALLBACK function
Public Sub TimerCallback(ByVal hWnd As Long, ByVal uMsg As Long, ByVal idEvent As Long, ByVal dwTime As Long)
    If (BASS_ChannelIsActive(RECORDCHAN) = 0) Then
        Call Stop_
    Else
        Call UpdateDisplay
    End If
End Sub
